## DeepSeek-R1的四个训练阶段


DeepSeek-R1的训练流程包含四个阶段，分为两个强化学习（RL）阶段和两个监督微调（SFT）阶段。

https://github.com/deepseek-ai/DeepSeek-R1

## 第一阶段：Cold Start（冷启动，SFT阶段）

### 要解决的问题

- **初始不稳定性和可读性差**：直接从基模型启动RL训练可能导致输出混乱（如语言混合、格式不统一）。
- **缺乏人类友好的推理模式**：需要为模型提供初始的规范化推理行为。

### 数据来源

人工收集的数千条高质量长链思维（CoT）数据，经过格式规范化和多语言对齐处理。

### 具体方法

**收集冷启动数据**：通过少量高质量的长链思维（CoT）数据，包括人工设计的示例、DeepSeek-R1-Zero的输出后处理、多语言对齐的格式（如 <reasoning_process> 和

1. 标签）。
2. **监督微调（SFT）**：用收集的数千条数据对基模型（DeepSeek-V3-Base）进行微调，确保输出格式规范且可读性强，为后续RL提供稳定的初始策略。

## 第二阶段：Reasoning-Oriented RL（面向推理的强化学习，RL阶段）

### 要解决的问题

- **提升核心推理能力**：增强模型在数学、代码、科学等领域的复杂推理性能。
- **语言混合问题**：确保推理过程中使用目标语言的一致性。

### 输入模型

冷启动SFT后的检查点。

### 具体方法

1. **GRPO算法**：采用分组相对策略优化（Group Relative Policy Optimization），通过规则奖励（如答案准确性、格式一致性）驱动模型优化。
2. **语言一致性奖励**：引入语言比例奖励（如目标语言词汇占比），减少多语言混合现象。
3. **混合奖励信号**：将准确性奖励与语言一致性奖励直接相加，形成最终奖励函数，指导模型生成更规范的推理过程。

## 第三阶段：Rejection Sampling & SFT（拒绝采样与监督微调，SFT阶段）

### 要解决的问题

- **多领域能力扩展**：增强模型在非推理任务（如写作、事实问答）上的通用性。
- **数据质量过滤**：筛选高质量的推理轨迹并生成多样化数据。

### 数据来源

- **推理数据**：通过拒绝采样从第二阶段的RL检查点生成，筛选正确的推理轨迹（约60万条）。
- **非推理数据**：复用DeepSeek-V3的SFT数据集（写作、事实问答等，约20万条）。

### 具体方法

1. **拒绝采样生成数据**：从RL检查点采样多个响应，仅保留正确的推理轨迹，并结合生成式奖励模型（如调用DeepSeek-V3判断质量）。
2. **混合非推理数据**：复用DeepSeek-V3的SFT数据（写作、翻译等），总计约80万样本（推理相关60万 + 非推理20万）。
3. **两轮监督微调**：用混合数据集对模型进行两轮微调，平衡推理与非推理能力。

## 第四阶段：RL for All Scenarios（全场景强化学习，RL阶段）

### 要解决的问题

- **与人类偏好对齐**：提升模型的安全性（Harmlessness）和实用性（Helpfulness）。
- **复杂场景泛化**：确保模型在开放域问答、长文本理解等任务中表现稳健。

### 输入模型

第三阶段SFT后的检查点。

### 具体方法

1. **多样化奖励信号**：

- **推理任务**：沿用规则奖励（数学、代码等）。
- **通用任务**：使用神经奖励模型评估人类偏好（如最终答案的实用性、全响应的无害性）。

2. **多提示分布训练**：结合不同场景的提示数据（如用户查询、角色扮演），确保模型适应多样化需求。
3. **二次RL训练**：在收敛的检查点上进一步优化，最终得到兼具推理能力和通用性的DeepSeek-R1模型。

## 总结

- **两个SFT阶段**：提供初始规范化能力（冷启动）和扩展多领域泛化性（混合数据微调）。
- **两个RL阶段**：分别针对核心推理能力提升（面向推理的RL）和人类偏好对齐（全场景RL）。
- **核心创新**：通过纯RL激励推理能力（无需SFT种子）的探索，结合冷启动和迭代优化，最终实现与顶尖闭源模型（如OpenAI-o1-1217）匹敌的性能。

阶段划分逻辑：

1. **SFT阶段1（冷启动）**：提供初始推理能力。
2. **RL阶段1（推理优化）**：提升核心推理性能。
3. **SFT阶段2（混合数据）**：扩展通用能力。
4. **RL阶段2（全场景对齐）**：最终优化与对齐。



> 来源：https://www.cnblogs.com/ghj1976/p/18707068/deepseekr1de-si-ge-xun-lian-jie-duan?utm_source=chatgpt.com